local gettext = require("i_18n")
_ = gettext.translate

rCounterGage = {valmin = 0, valmax = 1, dvalue = 2}

local count = -1
local function counter()
	count = count + 1
	return count
end

--------- GUNS ---------
GUN_FAIL_LEFT_OUT_GUN 	  		= counter()
GUN_FAIL_RIGHT_OUT_GUN	  		= counter()
GUN_FAIL_LEFT_CENTER_GUN 	  	= counter()
GUN_FAIL_RIGHT_CENTER_GUN	  	= counter()
GUN_FAIL_LEFT_IN_GUN 	  		= counter()
GUN_FAIL_RIGHT_IN_GUN	  		= counter()

GUN_LEFT_OUT_OPEN_CIRCUIT 		= counter()
GUN_LEFT_CENTER_OPEN_CIRCUIT 	= counter()
GUN_LEFT_IN_OPEN_CIRCUIT 		= counter()

GUN_RIGHT_IN_OPEN_CIRCUIT 		= counter()
GUN_RIGHT_CENTER_OPEN_CIRCUIT 	= counter()
GUN_RIGHT_OUT_OPEN_CIRCUIT 		= counter()

GUN_LEFT_OUT_AMMUN_FAULT 		= counter()
GUN_LEFT_CENTER_AMMUN_FAULT 	= counter()
GUN_LEFT_IN_AMMUN_FAULT 		= counter()

GUN_RIGHT_IN_AMMUN_FAULT 		= counter()
GUN_RIGHT_CENTER_AMMUN_FAULT 	= counter()
GUN_RIGHT_OUT_AMMUN_FAULT 		= counter()

GUN_LEFT_OUT_MOUNT_LOOSE		= counter()
GUN_LEFT_CENTER_MOUNT_LOOSE		= counter()
GUN_LEFT_IN_MOUNT_LOOSE			= counter()

GUN_RIGHT_IN_MOUNT_LOOSE		= counter()
GUN_RIGHT_CENTER_MOUNT_LOOSE	= counter()
GUN_RIGHT_OUT_MOUNT_LOOSE		= counter()

GUN_LEFT_OUT_BARREL_WORN		= counter()
GUN_LEFT_CENTER_BARREL_WORN		= counter()
GUN_LEFT_IN_BARREL_WORN			= counter()

GUN_RIGHT_IN_BARREL_WORN		= counter()
GUN_RIGHT_CENTER_BARREL_WORN	= counter()
GUN_RIGHT_OUT_BARREL_WORN		= counter()

GUN_LEFT_OUT_OVERHEATING		= counter()
GUN_LEFT_CENTER_OVERHEATING		= counter()
GUN_LEFT_IN_OVERHEATING			= counter()

GUN_RIGHT_IN_OVERHEATING		= counter()
GUN_RIGHT_CENTER_OVERHEATING	= counter()
GUN_RIGHT_OUT_OVERHEATING		= counter()

GUN_LEFT_OUT_SUPERCOOLING		= counter()
GUN_LEFT_CENTER_SUPERCOOLING	= counter()
GUN_LEFT_IN_SUPERCOOLING		= counter()

GUN_RIGHT_IN_SUPERCOOLING		= counter()
GUN_RIGHT_CENTER_SUPERCOOLING	= counter()
GUN_RIGHT_OUT_SUPERCOOLING		= counter()

GUN_LEFT_OUT_OVERLOAD_JAM		= counter()
GUN_LEFT_CENTER_OVERLOAD_JAM	= counter()
GUN_LEFT_IN_OVERLOAD_JAM		= counter()
				
GUN_RIGHT_IN_OVERLOAD_JAM		= counter()
GUN_RIGHT_CENTER_OVERLOAD_JAM	= counter()
GUN_RIGHT_OUT_OVERLOAD_JAM		= counter()
--------- BOMBS ---------
BOMBS_NO_VOLATAGE_AT_RACK_LEFT	= counter()
BOMBS_NO_VOLATAGE_AT_RACK_RIGHT	= counter()

BOMBS_DAMAGE_LINKAGE_LEFT	  	= counter()
BOMBS_DAMAGE_LINKAGE_RIGHT	  	= counter()

BOMBS_ARMING_NO_VOLATAGE_LEFT	= counter()
BOMBS_ARMING_NO_VOLATAGE_RIGHT	= counter()

BOMBS_NO_VOLATAGE_BOTH			= counter()
BOMBS_ARMING_NO_VOLATAGE_BOTH	= counter()

BOMBS_DAMAGE_ELINKAGE_LEFT	  	= counter()
BOMBS_DAMAGE_ELINKAGE_RIGHT	  	= counter()

BOMBS_SOLENOID_FAULT_LEFT	  	= counter()
BOMBS_SOLENOID_FAULT_RIGHT	  	= counter()

BOMBS_RUST_LEFT	  				= counter()
BOMBS_RUST_RIGHT	  			= counter()

BOMBS_ARMING_BROKEN_WIRING_LEFT	= counter()
BOMBS_ARMING_BROKEN_WIRING_RIGHT= counter()

BOMBS_ARMING_BROKEN_SOLENOID_LEFT	= counter()
BOMBS_ARMING_BROKEN_SOLENOID_RIGHT 	= counter()

BOMBS_TRAIN_DEFECTIVE_WIRING	= counter()
BOMBS_TRAIN_DEFECTIVE_SWITCH 	= counter()

--------- ROCKETS ---------
ROCKETS_DEFECTIVE_WIRING 	  	= counter()
FAULTY_ROCKET_LEFT 				= counter()
FAULTY_ROCKET_RIGHT 			= counter()
ROCKETS_INTERVALOMETER_WIRING 	= counter()
ROCKETS_INTERVALOMETER_SEQ 		= counter()



Damage = {	
	{Failure = GUN_FAIL_LEFT_OUT_GUN, Failure_name = "GUN_FAIL_LEFT_OUT_GUN", Failure_editor_name = _("Defective left outboard gun"),  Element = 29, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_FAIL_RIGHT_OUT_GUN, Failure_name = "GUN_FAIL_RIGHT_OUT_GUN", Failure_editor_name = _("Defective right outboard gun"),  Element = 30, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_FAIL_LEFT_CENTER_GUN, Failure_name = "GUN_FAIL_LEFT_CENTER_GUN", Failure_editor_name = _("Defective left center gun"),  Element = 29, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_FAIL_RIGHT_CENTER_GUN, Failure_name = "GUN_FAIL_RIGHT_CENTER_GUN", Failure_editor_name = _("Defective right center gun"),  Element = 30, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_FAIL_LEFT_IN_GUN, Failure_name = "GUN_FAIL_LEFT_IN_GUN", Failure_editor_name = _("Defective left inboard gun"),  Element = 29, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_FAIL_RIGHT_IN_GUN, Failure_name = "GUN_FAIL_RIGHT_IN_GUN", Failure_editor_name = _("Defective right inboard gun"),  Element = 30, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	
	{Failure = GUN_LEFT_OUT_OPEN_CIRCUIT, Failure_name = "GUN_LEFT_OUT_OPEN_CIRCUIT", Failure_editor_name = _("Left outboard gun wiring fault"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_OPEN_CIRCUIT, Failure_name = "GUN_LEFT_CENTER_OPEN_CIRCUIT", Failure_editor_name = _("Left center gun wiring fault"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_OPEN_CIRCUIT, Failure_name = "GUN_LEFT_IN_OPEN_CIRCUIT", Failure_editor_name = _("Left inboard gun wiring fault"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	
	{Failure = GUN_RIGHT_IN_OPEN_CIRCUIT, Failure_name = "GUN_RIGHT_IN_OPEN_CIRCUIT", Failure_editor_name = _("Right inboard gun wiring fault"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_OPEN_CIRCUIT, Failure_name = "GUN_RIGHT_CENTER_OPEN_CIRCUIT", Failure_editor_name = _("Right center gun wiring fault"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_OPEN_CIRCUIT, Failure_name = "GUN_RIGHT_OUT_OPEN_CIRCUIT", Failure_editor_name = _("Right outboard gun wiring fault"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	
	{Failure = GUN_LEFT_OUT_AMMUN_FAULT, Failure_name = "GUN_LEFT_OUT_AMMUN_FAULT", Failure_editor_name = _("Left outboard gun ammunition fault"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_AMMUN_FAULT, Failure_name = "GUN_LEFT_CENTER_AMMUN_FAULT", Failure_editor_name = _("Left center gun ammunition fault"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_AMMUN_FAULT, Failure_name = "GUN_LEFT_IN_AMMUN_FAULT", Failure_editor_name = _("Left inboard gun ammunition fault"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_AMMUN_FAULT, Failure_name = "GUN_RIGHT_IN_AMMUN_FAULT", Failure_editor_name = _("Right inboard gun ammunition fault"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_AMMUN_FAULT, Failure_name = "GUN_RIGHT_CENTER_AMMUN_FAULT", Failure_editor_name = _("Right center gun ammunition fault"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_AMMUN_FAULT, Failure_name = "GUN_RIGHT_OUT_AMMUN_FAULT", Failure_editor_name = _("Right outboard gun ammunition fault"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_LEFT_OUT_MOUNT_LOOSE, Failure_name = "GUN_LEFT_OUT_MOUNT_LOOSE", Failure_editor_name = _("Left outboard gun mount loose"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_MOUNT_LOOSE, Failure_name = "GUN_LEFT_CENTER_MOUNT_LOOSE", Failure_editor_name = _("Left center gun mount loose"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_MOUNT_LOOSE, Failure_name = "GUN_LEFT_IN_MOUNT_LOOSE", Failure_editor_name = _("Left inboard gun mount loose"),  Element = 29, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_MOUNT_LOOSE, Failure_name = "GUN_RIGHT_IN_MOUNT_LOOSE", Failure_editor_name = _("Right inboard gun mount loose"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_MOUNT_LOOSE, Failure_name = "GUN_RIGHT_CENTER_MOUNT_LOOSE", Failure_editor_name = _("Right center gun mount loose"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_MOUNT_LOOSE, Failure_name = "GUN_RIGHT_OUT_MOUNT_LOOSE", Failure_editor_name = _("Right outboard gun mount loose"),  Element = 30, Integrity_Treshold = 0.4, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_LEFT_OUT_BARREL_WORN, Failure_name = "GUN_LEFT_OUT_BARREL_WORN", Failure_editor_name = _("Left outboard gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_BARREL_WORN, Failure_name = "GUN_LEFT_CENTER_BARREL_WORN", Failure_editor_name = _("Left center gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_BARREL_WORN, Failure_name = "GUN_LEFT_IN_BARREL_WORN", Failure_editor_name = _("Left inboard gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_BARREL_WORN, Failure_name = "GUN_RIGHT_IN_BARREL_WORN", Failure_editor_name = _("Right inboard gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_BARREL_WORN, Failure_name = "GUN_RIGHT_CENTER_BARREL_WORN", Failure_editor_name = _("Right center gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_BARREL_WORN, Failure_name = "GUN_RIGHT_OUT_BARREL_WORN", Failure_editor_name = _("Right outboard gun worn"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = GUN_LEFT_OUT_OVERHEATING, Failure_name = "GUN_LEFT_OUT_OVERHEATING", Failure_editor_name = _("Left outboard gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_OVERHEATING, Failure_name = "GUN_LEFT_CENTER_OVERHEATING", Failure_editor_name = _("Left center gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_OVERHEATING, Failure_name = "GUN_LEFT_IN_OVERHEATING", Failure_editor_name = _("Left inboard gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_OVERHEATING, Failure_name = "GUN_RIGHT_IN_OVERHEATING", Failure_editor_name = _("Right inboard gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_OVERHEATING, Failure_name = "GUN_RIGHT_CENTER_OVERHEATING", Failure_editor_name = _("Right center gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_OVERHEATING, Failure_name = "GUN_RIGHT_OUT_OVERHEATING", Failure_editor_name = _("Right outboard gun overheating"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	{Failure = GUN_LEFT_OUT_SUPERCOOLING, Failure_name = "GUN_LEFT_OUT_SUPERCOOLING", Failure_editor_name = _("Left outboard gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_SUPERCOOLING, Failure_name = "GUN_LEFT_CENTER_SUPERCOOLING", Failure_editor_name = _("Left center gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_SUPERCOOLING, Failure_name = "GUN_LEFT_IN_SUPERCOOLING", Failure_editor_name = _("Left inboard gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_SUPERCOOLING, Failure_name = "GUN_RIGHT_IN_SUPERCOOLING", Failure_editor_name = _("Right inboard gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_SUPERCOOLING, Failure_name = "GUN_RIGHT_CENTER_SUPERCOOLING", Failure_editor_name = _("Right center gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_SUPERCOOLING, Failure_name = "GUN_RIGHT_OUT_SUPERCOOLING", Failure_editor_name = _("Right outboard gun supercooling"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	{Failure = GUN_LEFT_OUT_OVERLOAD_JAM, Failure_name = "GUN_LEFT_OUT_OVERLOAD_JAM", Failure_editor_name = _("Left outboard gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_CENTER_OVERLOAD_JAM, Failure_name = "GUN_LEFT_CENTER_OVERLOAD_JAM", Failure_editor_name = _("Left center gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_LEFT_IN_OVERLOAD_JAM, Failure_name = "GUN_LEFT_IN_OVERLOAD_JAM", Failure_editor_name = _("Left inboard gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	{Failure = GUN_RIGHT_IN_OVERLOAD_JAM, Failure_name = "GUN_RIGHT_IN_OVERLOAD_JAM", Failure_editor_name = _("Right inboard gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_CENTER_OVERLOAD_JAM, Failure_name = "GUN_RIGHT_CENTER_OVERLOAD_JAM", Failure_editor_name = _("Right center gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},
	{Failure = GUN_RIGHT_OUT_OVERLOAD_JAM, Failure_name = "GUN_RIGHT_OUT_OVERLOAD_JAM", Failure_editor_name = _("Right outboard gun overload jam"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.0, work_time_to_fail = 3600*300},

	--------- BOMBS ---------
	{Failure = BOMBS_NO_VOLATAGE_AT_RACK_LEFT, Failure_name = "BOMBS_NO_VOLATAGE_AT_RACK_LEFT", Failure_editor_name = _("Bombs. No voltage at left rack"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_NO_VOLATAGE_AT_RACK_RIGHT, Failure_name = "BOMBS_NO_VOLATAGE_AT_RACK_RIGHT", Failure_editor_name = _("Bombs. No voltage at right rack"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_DAMAGE_LINKAGE_LEFT, Failure_name = "BOMBS_DAMAGE_LINKAGE_LEFT", Failure_editor_name = _("Bombs. Left rack release linkage defective"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_DAMAGE_LINKAGE_RIGHT, Failure_name = "BOMBS_DAMAGE_LINKAGE_RIGHT", Failure_editor_name = _("Bombs. Right rack release linkage defective"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_ARMING_NO_VOLATAGE_LEFT, Failure_name = "BOMBS_ARMING_NO_VOLATAGE_LEFT", Failure_editor_name = _("Bombs. Left rack arming latch does not lock"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_ARMING_NO_VOLATAGE_RIGHT, Failure_name = "BOMBS_ARMING_NO_VOLATAGE_RIGHT", Failure_editor_name = _("Bombs. Right rack arming latch does not lock"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	
	{Failure = BOMBS_NO_VOLATAGE_BOTH, Failure_name = "BOMBS_NO_VOLATAGE_BOTH", Failure_editor_name = _("Bombs. No voltage at both racks"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_ARMING_NO_VOLATAGE_BOTH, Failure_name = "BOMBS_ARMING_NO_VOLATAGE_BOTH", Failure_editor_name = _("Bombs. Both racks arming latch does not lock"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	
	{Failure = BOMBS_DAMAGE_ELINKAGE_LEFT, Failure_name = "BOMBS_DAMAGE_ELINKAGE_LEFT", Failure_editor_name = _("Bombs. Left rack electrical linkage damaged"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_DAMAGE_ELINKAGE_RIGHT, Failure_name = "BOMBS_DAMAGE_ELINKAGE_RIGHT", Failure_editor_name = _("Bombs. Right rack electrical linkage damaged"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_SOLENOID_FAULT_LEFT, Failure_name = "BOMBS_SOLENOID_FAULT_LEFT", Failure_editor_name = _("Bombs. Left rack solenoid fault"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_SOLENOID_FAULT_RIGHT, Failure_name = "BOMBS_SOLENOID_FAULT_RIGHT", Failure_editor_name = _("Bombs. Right rack solenoid fault"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_RUST_LEFT, Failure_name = "BOMBS_RUST_LEFT", Failure_editor_name = _("Bombs. Left rack corrosion"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_RUST_RIGHT, Failure_name = "BOMBS_RUST_RIGHT", Failure_editor_name = _("Bombs. Right rack corrosion"),  Element = -1, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_ARMING_BROKEN_WIRING_LEFT, Failure_name = "BOMBS_ARMING_BROKEN_WIRING_LEFT", Failure_editor_name = _("Bombs. Left rack arm broken wiring"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_ARMING_BROKEN_WIRING_RIGHT, Failure_name = "BOMBS_ARMING_BROKEN_WIRING_RIGHT", Failure_editor_name = _("Bombs. Right rack arm broken wiring"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_ARMING_BROKEN_SOLENOID_LEFT, Failure_name = "BOMBS_ARMING_BROKEN_SOLENOID_LEFT", Failure_editor_name = _("Bombs. Left rack arm solenoid fail"),  Element = 29, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_ARMING_BROKEN_SOLENOID_RIGHT, Failure_name = "BOMBS_ARMING_BROKEN_SOLENOID_RIGHT", Failure_editor_name = _("Bombs. Right rack arm solenoid fail"),  Element = 30, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	{Failure = BOMBS_TRAIN_DEFECTIVE_WIRING, Failure_name = "BOMBS_TRAIN_DEFECTIVE_WIRING", Failure_editor_name = _("Bombs. Train wiring fault"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = BOMBS_TRAIN_DEFECTIVE_SWITCH, Failure_name = "BOMBS_TRAIN_DEFECTIVE_SWITCH", Failure_editor_name = _("Bombs. Transfer switch fault"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},

	--------- ROCKETS ---------
	{Failure = ROCKETS_DEFECTIVE_WIRING, Failure_name = "ROCKETS_DEFECTIVE_WIRING", Failure_editor_name = _("Rockets. Defective wiring"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = FAULTY_ROCKET_LEFT, Failure_name = "FAULTY_ROCKET_LEFT", Failure_editor_name = _("Rockets. Faulty left wing rocket"),  Element = 29, Integrity_Treshold = 0.2, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = FAULTY_ROCKET_RIGHT, Failure_name = "FAULTY_ROCKET_RIGHT", Failure_editor_name = _("Rockets. Faulty right wing rocket"),  Element = 30, Integrity_Treshold = 0.2, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = ROCKETS_INTERVALOMETER_WIRING, Failure_name = "ROCKETS_INTERVALOMETER_WIRING", Failure_editor_name = _("Rockets. Intervalometer. Defective wiring"),  Element = 3, Integrity_Treshold = 0.05, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = ROCKETS_INTERVALOMETER_SEQ, Failure_name = "ROCKETS_INTERVALOMETER_SEQ", Failure_editor_name = _("Rockets. Intervalometer malfunctioning"),  Element = 3, Integrity_Treshold = 0.1, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
}

ElecConsumerParamsGunHeater        = {80, true, 5, 7}
ElecConsumerParamsGunFireSolenoid  = {6, false, 15, 17}
ElecConsumerParamsGunCamera        = {20, true, 18, 19} -- 10 watt for camera, and 10 for camera heater
-- rocket fire 10-15 Watt
-- bomb arm solenoids
ElecConsumerParamsBombArmSolenoid  = {1.5, false, 17, 19}
-- bomb release solenoids
ElecConsumerParamsBombReleaseSolenoid = {5, false, 17, 19}

need_to_be_closed = true -- close lua state after initialization
